/***********************************************************************
* 
*      Filename                : FileLibrary.h
*      Module Name (s)         : 
* 
* Copyright (c) 2007 Texas Instruments, Inc.
* This is an unpublished work created in the year stated above.
* Texas Instruments owns all rights in and to this work and
* intends to maintain and protect it as an unpublished copyright.
* In the event of either inadvertent or deliberate publication,
* the above stated date shall be treated as the year of first
* publication.  In the event of such publication, Texas Instruments
* intends to enforce its rights in the work under the copyright
* laws as a published work.
* 
* These commodities are under U.S. Government 'distribution license'
* control.  As such they are not to be re-exported without prior
* approval from the U.S. Department of Commerce.
* 
* **********************************************************************
* 
* Author:              
*
* Revision History:    Rev 1.0  01.20.07  Original Version
* 
* **********************************************************************
* 
* Module Description:  Header file for File I/O type operations.
*
* **********************************************************************
*/

#if !defined(_FILELIBRARY_H_)
#define _FILELIBRARY_H_

BOOL bReadFileToArray2(CString sFile, int *nMaxFileSize, char *cData) ;
BOOL bReadFileToArray(CString sFile, int *nMaxFileSize, char *cData) ;
BOOL bWriteArrayToFile(CString sFile, int *nMaxFileSize, char *cData) ;
BOOL bWriteArrayInfoToFile(CString sFile, CString sInfoFile, int *nMaxFileSize, char *cInfo) ;
int HexStringToInt(CString sString) ;
void SwapEndianWord(char *string);
BOOL SwapEndian(int *nMaxFileSize,char *cData);
BOOL HEXtoBinary(int *nMaxFileSize,char *cData);
BOOL MotHEXtoBinary(int *nMaxFileSize,char *cData);
BOOL IntelHEXtoBinary(int *nMaxFileSize,char *cData);
BOOL BuildBlockAddrArray(int *nMaxFileSize,char *cData, long *nBlockAddr, int *nBlockCount);
BOOL SortBlockAddrArray(long *nBlockAddr, int *nBlockCount);
BOOL SortBlockDataRecords(int *nMaxFileSize,char *cData, long *nBlockAddr, int *nBlockCount);
BOOL RemoveExtraInfo(int *nMaxFileSize,char *cData, long *nBlockAddr, int *nBlockCount);


//#define MAXFILESIZE 65536
#define MAXFILESIZE		700000
#define MAXBLOCKNUM		100
#define	BLOCKHEADER		6

#endif // !defined(_FILELIBRARY_H_)
